/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.configeditor;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;
import potionstudios.byg.client.config.configeditor.AddConfigEditEntryEntry;
import potionstudios.byg.client.config.configeditor.ConfigCollectionEntry;
import potionstudios.byg.client.config.configeditor.ConfigEditEntry;
import potionstudios.byg.client.config.filebrowser.FileBrowserScreen;
import potionstudios.byg.client.config.serializers.ConfigEntriesSerializer;

public class ConfigEditScreen
extends class_437 {
    private final class_437 parent;
    private final ConfigEntriesSerializer<?> file;
    private final String shownPath;
    @Nullable
    private final Path absolutePath;
    private final boolean reloadsOnSave;
    private ConfigMap<?> configEntries;
    private String searchCache = "";
    private class_342 searchBox;
    private final Set<ConfigEditEntry<?>> hidden = new ObjectOpenHashSet();

    public ConfigEditScreen(class_437 parent, ConfigEntriesSerializer<?> element, String relativizedPath) {
        this(parent, element, relativizedPath, null, false);
    }

    public ConfigEditScreen(class_437 parent, ConfigEntriesSerializer<?> element, String relativizedPath, @Nullable Path filePath, boolean reloadsOnSave) {
        super((class_2561)class_2561.method_43470((String)String.format("Editing config file: \"%s\"", relativizedPath.toString())));
        this.parent = parent;
        this.file = element;
        this.shownPath = relativizedPath;
        this.absolutePath = filePath;
        this.reloadsOnSave = reloadsOnSave;
    }

    public void method_25393() {
        this.configEntries.method_25396().forEach(ConfigEditEntry::tick);
        this.searchBox.method_1865();
    }

    protected void method_25426() {
        this.configEntries = new ConfigMap(this, this.field_22789, this.field_22790, 40, this.field_22790 - 37, 25);
        int maxCommentWidth = this.configEntries.method_25322();
        for (ConfigEditEntry<?> entry : this.file.createEntries(this, this.shownPath)) {
            this.configEntries.addEntry(entry);
            maxCommentWidth = Math.max(maxCommentWidth, entry.getRowWidth());
        }
        this.addConfigEntryButton();
        this.configEntries.rowWidth = maxCommentWidth;
        int searchWidth = 250;
        this.searchBox = new class_342(class_310.method_1551().field_1772, this.field_22789 / 2 - searchWidth / 2, 18, searchWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.searchBox.method_1863(this::searchResponder);
        int buttonWidth = 150;
        this.method_37063((class_364)new class_4185(this.field_22789 - this.field_22789 / 2 - buttonWidth / 2, this.field_22790 - 30, buttonWidth, 20, class_5244.field_24334, p_95761_ -> this.save()));
        this.method_37063((class_364)this.searchBox);
        this.method_25429((class_364)this.configEntries);
        super.method_25426();
    }

    public void method_25394(class_4587 pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(pPoseStack);
        this.configEntries.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        ConfigEditScreen.method_27534((class_4587)pPoseStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)5, (int)0xFFFFFF);
        super.method_25394(pPoseStack, pMouseX, pMouseY, pPartialTick);
        for (ConfigEditEntry child : this.configEntries.method_25396()) {
            if (!child.renderToolTip) continue;
            this.method_25417(pPoseStack, child.toolTip, pMouseX, pMouseY);
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private void addConfigEntryButton() {
        BiFunction<String, String, ConfigEditEntry<?>> makeEntry = (key, value) -> {
            Object value1;
            String shownPath = this.file.path() + "." + key;
            if (value.equalsIgnoreCase("list")) {
                return new ConfigCollectionEntry(this, (String)key, this.file.makeList(shownPath), (class_2561)class_2561.method_43470((String)""));
            }
            if (value.equalsIgnoreCase("map")) {
                return new ConfigCollectionEntry(this, (String)key, this.file.makeMap(shownPath), (class_2561)class_2561.method_43470((String)""));
            }
            try {
                long parseLong;
                value1 = value.contains(".") ? (Number)Double.parseDouble(value) : (Number)((parseLong = Long.parseLong(value)) <= Integer.MAX_VALUE ? (Number)((int)parseLong) : (Number)parseLong);
            }
            catch (Exception e) {
                value1 = value;
            }
            return ConfigEntriesSerializer.makePrimitiveEntry(key, value1, this);
        };
        AddConfigEditEntryEntry addConfigEditEntryEntry = new AddConfigEditEntryEntry(this, this.configEntries, makeEntry, "");
        this.configEntries.addEntry(addConfigEditEntryEntry);
    }

    private void searchResponder(String s) {
        if (!this.searchCache.equals(s)) {
            List children = this.configEntries.method_25396();
            ArrayList keyCommentToolTipEntries = new ArrayList(children);
            for (ConfigEditEntry child : keyCommentToolTipEntries) {
                if (child.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.remove((Object)child);
                child.renderToolTip = false;
                this.hidden.add(child);
            }
            for (ConfigEditEntry entry : new ObjectOpenHashSet(this.hidden)) {
                if (!entry.key.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
                children.add(entry);
                this.hidden.remove((Object)entry);
            }
            this.searchCache = s;
            this.configEntries.method_25307(0.0);
        }
    }

    private void save() {
        StringBuilder errors = new StringBuilder(this.file.save(this.configEntries.method_25396()));
        if (errors.isEmpty() && this.parent instanceof FileBrowserScreen && this.absolutePath != null) {
            try {
                this.file.saveFile(this.absolutePath);
                if (this.reloadsOnSave) {
                    FileBrowserScreen.ON_RELOAD.accept(this.absolutePath);
                }
                this.field_22787.method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43470((String)"Saved Config File:"), (class_2561)class_2561.method_43470((String)this.shownPath)));
            }
            catch (Exception e) {
                errors.append(e.getMessage());
            }
        }
        if (!errors.isEmpty()) {
            this.field_22787.method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_371)class_370.class_371.field_21809, (class_2561)class_2561.method_43470((String)"Could not save File."), (class_2561)class_2561.method_43470((String)errors.toString())));
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }

    public static class ConfigMap<T>
    extends class_4265<ConfigEditEntry<T>> {
        private final class_437 screen;
        private int rowWidth = super.method_25322();

        public ConfigMap(class_437 screen, int width, int height, int y0, int y1, int itemHeight) {
            super(class_310.method_1551(), width, height, y0, y1, itemHeight);
            this.screen = screen;
            this.method_31322(false);
        }

        protected boolean method_25316() {
            return this.screen.method_25399() == this;
        }

        public int addEntry(ConfigEditEntry $$0) {
            return super.method_25321((class_350.class_351)$$0);
        }

        protected int method_25329() {
            return this.field_22742 - 10;
        }

        public int method_25322() {
            return this.rowWidth;
        }
    }
}

